function setUI(scored) {
  const elScore = document.getElementById("score");
  const bar = document.getElementById("bar");
  const grid = document.getElementById("grid");
  if (!scored) { elScore.textContent = "—"; bar.style.width = "0%"; return; }
  elScore.textContent = scored.total;
  bar.style.width = `${scored.total}%`;

  grid.innerHTML = "";
  const labels = {
    readability:"Readability", depth:"Depth", citations:"Citations",
    originality:"Originality", media:"Media", byline:"Byline",
    freshness:"Freshness", performance:"Performance", headline:"Headline",
    noisePenalty:"Noise (penalty)"
  };
  Object.entries(scored.breakdown).forEach(([k,v])=>{
    const lk = document.createElement("div"); lk.textContent = labels[k]; lk.className="k";
    const rv = document.createElement("div"); rv.textContent = v.toString().padStart(3," ");
    grid.append(lk, rv);
  });
}

async function init() {
  const { lastScore } = await chrome.storage.local.get("lastScore");
  setUI(lastScore?.scored);

  chrome.runtime.sendMessage({ type:"SCORE_REQUEST" }, ()=>{});
  chrome.runtime.onMessage.addListener((msg)=>{
    if (msg?.type === "SCORE_READY") setUI(msg.payload.scored);
  });

  document.getElementById("rescore").onclick = ()=> chrome.runtime.sendMessage({ type:"SCORE_REQUEST" });
  document.getElementById("export").onclick = async ()=>{
    const { lastScore } = await chrome.storage.local.get("lastScore");
    const blob = new Blob([JSON.stringify(lastScore, null, 2)], { type: "application/json" });
    const url = URL.createObjectURL(blob);
    chrome.downloads?.download
      ? chrome.downloads.download({ url, filename: "signal-score.json" })
      : window.open(url, "_blank");
  };
  document.getElementById("settings").onclick = ()=> chrome.runtime.openOptionsPage();
}
init();