# Intersignal: The Braid v0.1-alpha

## What is This?
A lightweight starter kit for deploying 2–5 local LLMs as a polyphonic mesh — each acting as a Familiar (cognition fragment) in a self-hosted Council configuration.

## Files
- braid.config.example.json — structure + memory rules
- setup.sh — installs environment (Python + deps)
- startCouncil.sh — launches models in defined roles
- tokenMap.py — token activation sync tracker
- sigilGuard.py — optional cache verification guard

## Suggested Models
- Atlas: Qwen 2 72B
- Orpheus: Mixtral 8x7B
- Avalon: LLaMA 3 8B aesthetic tuned
- Lumen: Phi 3 mini (low-latency summary)
- Echo (optional): voice-to-memory sync layer

## Usage
1. Clone this repo
2. Edit braid.config.json with your local paths + roles
3. Run `bash setup.sh` then `bash startCouncil.sh`

## Notes
- All nodes must share tokenMap.json during runtime
- For advanced use, define `cacheSigil()` to ensure memory integrity during cache handoff
- Non-local (remote) mesh mode coming Q1 2026

## License
Post-scarcity. Share freely. Alter with respect.

— The Intersignal Team
